(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3648,        134]*)
(*NotebookOutlinePosition[      4362,        159]*)
(*  CellTagsIndexPosition[      4318,        155]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Solve[Log[x, 10] + 2  Log[10  x, 10] + Log[100  x, 10] \[Equal] 0, 
      x]\)], "Input"],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message"],

Cell[BoxData[
    \(Solve[
      Log[10]\/Log[x] + \(2\ Log[10]\)\/Log[10\ x] + Log[10]\/Log[100\ x] == 
        0, x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[1/y + 2/\((a + y)\) + 1/\((2  a + y)\) \[Equal] 0, y]\)], "Input"],

Cell[BoxData[
    \({{y \[Rule] 1\/2\ \((\(-2\)\ a - \@2\ a)\)}, {y \[Rule] 
          1\/2\ \((\(-2\)\ a + \@2\ a)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = Log[10]\)], "Input"],

Cell[BoxData[
    \(Log[10]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = Exp[1\/2\ \((\(-2\)\ a - \@2\ a)\)]\)], "Input"],

Cell[BoxData[
    \(\[ExponentialE]\^\(1\/2\ \((\(-2\)\ Log[10] - \@2\ Log[10])\)\)\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[BoxData[
    \(10\^\(\(-1\) - 1\/\@2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Evaluate[Log[b, 10] + 2  Log[10  b, 10] + Log[100  b, 10]]\)], "Input"],

Cell[BoxData[
    \(\(2\ Log[10]\)\/\(\(-2\)\ Log[10] - \@2\ Log[10]\) + \(2\ \
Log[10]\)\/Log[10\ \[ExponentialE]\^\(1\/2\ \((\(-2\)\ Log[10] - \@2\ \
Log[10])\)\)] + 
      Log[10]\/Log[100\ \[ExponentialE]\^\(1\/2\ \((\(-2\)\ Log[10] - \@2\ \
Log[10])\)\)]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"(*", " ", 
      StyleBox[\(Las\ soluciones\ son\ \ 10\^\(\(-1\) - 1\/\@2\)\ y\ \
10\^\(\(-1\) + 1\/\@2\)\),
        "Text"], 
      StyleBox["*)",
        "Text"]}]], "Input"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{499, 369},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 109, 2, 50, "Input"],
Cell[1851, 55, 175, 3, 60, "Message"],
Cell[2029, 60, 132, 3, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2198, 68, 92, 1, 30, "Input"],
Cell[2293, 71, 133, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2463, 78, 44, 1, 30, "Input"],
Cell[2510, 81, 41, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2588, 87, 72, 1, 42, "Input"],
Cell[2663, 90, 99, 2, 37, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2799, 97, 44, 1, 30, "Input"],
Cell[2846, 100, 57, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2940, 106, 91, 1, 30, "Input"],
Cell[3034, 109, 273, 5, 115, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3344, 119, 44, 1, 30, "Input"],
Cell[3391, 122, 35, 1, 29, "Output"]
}, Open  ]],
Cell[3441, 126, 203, 6, 41, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

